<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClientPayment extends Model 
{

    protected $table = 'client_payments';
    public $timestamps = true;
    protected $fillable = array('client_id', 'date', 'safe_id', 'amount', 'service_id');

    public function service()
    {
        return $this->belongsTo('App\Models\Service');
    }

    public function client()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function safe()
    {
        return $this->belongsTo('App\Models\Safe');
    }

}